<?php

class ControladorData
{
  
	static public function unirDataInicioEDataFim($dataInicio,$dataFim)
    {
       $data1 = ControladorData::ctrVerificarValidadeDaData($dataInicio);

       $data2 = ControladorData::ctrVerificarValidadeDaData($dataFim);
        
       if(($data1 > -1) && ($data2 > -1))
       {
           if (($data2 - $data1)>-1) {
                return $dataInicio."|".$dataFim;
           }else {
                return "Erro2";
           }
           
       }else {
                return "Erro1";
        }
       
    }

    static public function dataQueDeseja($dataInicioEdataFim,$NumeroDadataQueDesea0ou1)
    {
       $dataArray = explode("|",$dataInicioEdataFim);
       return $dataArray[$NumeroDadataQueDesea0ou1];
    }
 
    static public function diasRestantesDaDataDeHojeAteADataDeTermino($dataInicioEdataFim)
    {
        $dataArray = explode("|",$dataInicioEdataFim);
        $dataHoje = date("Y-m-d");
        $diferenca = strtotime($dataArray[1]) - strtotime($dataHoje);
		$tempoRestante = floor($diferenca / (60 * 60 * 24));
		return $tempoRestante;
		
    }

    static public function ctrVerificarValidadeDaData($dataEvento){
		$dataHoje = date("Y-m-d");
		$diferenca = strtotime($dataEvento) - strtotime($dataHoje);
		$tempoRestante = floor($diferenca / (60 * 60 * 24));
		if ($tempoRestante >= 0) {
			return 1;
		}else{
			return -1;
		}
		 

	}
    static public function ctrVerificarValidadeDaDataEmRelacaoADataHoje($data){
		$dataHoje = date("Y-m-d");
		$diferenca = strtotime($data) - strtotime($dataHoje);
		$tempoRestante = floor($diferenca / (60 * 60 * 24));
		return $tempoRestante;
	}

    static public function ctrVerificarValidadeDaDataDiaMesAnoEmRelacaoADataHoje($data){
		$dataHoje = date("d-m-Y");
		$diferenca = strtotime($data) - strtotime($dataHoje);
		$tempoRestante = floor($diferenca / (60 * 60 * 24));
		return $tempoRestante;
	}

  static public function ctrAdicionarDiasNaDataERetornarNovaData($data, $quantDiaUmento){
		// Converte a data para um objeto DateTime
    $dataObj = new DateTime($data);

    // Adiciona a quantidade de dias especificada
    $dataObj->add(new DateInterval("P{$quantDiaUmento}D"));

    // Formata a nova data no formato desejado (por exemplo, 'Y-m-d' para ano-mês-dia)
    $novaData = $dataObj->format('Y-m-d');

    return $novaData;
	}

  

}
	

?>